/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.cursee.more_bows_and_arrows.core.entity;

import neoforge.com.cursee.more_bows_and_arrows.core.entity.TieredArrowEntity;
import neoforge.com.cursee.more_bows_and_arrows.core.item.TieredBowItem;
import neoforge.com.cursee.more_bows_and_arrows.core.tier.BowTier;
import neoforge.com.cursee.more_bows_and_arrows.core.util.CommonEffectsUtil;
import neoforge.com.cursee.more_bows_and_arrows.core.util.DragonBreathUtil;
import neoforge.com.cursee.more_bows_and_arrows.core.util.FireworkUtil;
import neoforge.com.cursee.more_bows_and_arrows.core.util.PaperEffectsUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.RedStoneOreBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class ArrowHitsBlockInteractions {
    public static void interact(TieredArrowEntity tieredArrowEntity, @Nullable Entity nullableOwner, BlockHitResult blockHitResult) {
        if (!(nullableOwner instanceof Player)) {
            return;
        }
        Player player = (Player)nullableOwner;
        Level level = player.level();
        ItemStack itemStack = player.getMainHandItem();
        Item playerMainHandItem = itemStack.getItem();
        BlockPos blockPos = blockHitResult.getBlockPos();
        Direction direction = blockHitResult.getDirection();
        BlockPos relative = blockPos.relative(direction);
        switch (tieredArrowEntity.getVariant()) {
            case BAMBOO: {
                if (!(playerMainHandItem instanceof TieredBowItem)) {
                    return;
                }
                if (((TieredBowItem)playerMainHandItem).tier != BowTier.BAMBOO) {
                    return;
                }
                BlockState state = level.getBlockState(blockPos);
                if (!Blocks.BAMBOO.defaultBlockState().canSurvive((LevelReader)level, blockPos)) break;
                if (Feature.isDirt((BlockState)state)) {
                    level.setBlock(blockPos, Blocks.PODZOL.defaultBlockState(), 3);
                    level.setBlock(blockPos.above(), Blocks.BAMBOO.defaultBlockState(), 3);
                    break;
                }
                if (!state.is(Blocks.BAMBOO)) break;
                level.setBlock(blockPos.above(), Blocks.BAMBOO.defaultBlockState(), 3);
                break;
            }
            case BLAZE_ROD: {
                CommonEffectsUtil.lightOrIgniteBlock(blockHitResult, level);
                break;
            }
            case DRAGON_BREATH: {
                DragonBreathUtil.createAreaEffectCloud(player, blockHitResult.getBlockPos());
                break;
            }
            case ECHO: {
                if (!(level instanceof ServerLevel)) {
                    return;
                }
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.playSound(player, blockHitResult.getBlockPos(), SoundEvents.EVOKER_CAST_SPELL, SoundSource.PLAYERS, 1.0f, 1.0f);
                break;
            }
            case EGG: {
                Chicken chicken = (Chicken)EntityType.CHICKEN.create(level);
                if (chicken == null) break;
                chicken.moveTo((double)relative.getX(), (double)relative.getY(), (double)relative.getZ());
                level.addFreshEntity((Entity)chicken);
                break;
            }
            case ENDER_PEARL: {
                player.teleportTo((double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ());
                break;
            }
            case FIREWORK: {
                FireworkUtil.createRandomFireworkFromEntity((LivingEntity)player, blockHitResult.getBlockPos());
                break;
            }
            case FIRE_CHARGE: {
                CommonEffectsUtil.lightOrIgniteBlock(blockHitResult, level);
                break;
            }
            case FLINT: {
                if (!(playerMainHandItem instanceof TieredBowItem)) break;
                TieredBowItem bow = (TieredBowItem)playerMainHandItem;
                if (bow.tier != BowTier.IRON) break;
                CommonEffectsUtil.lightOrIgniteBlock(blockHitResult, level);
                break;
            }
            case FLINT_AND_STEEL: {
                CommonEffectsUtil.lightOrIgniteBlock(blockHitResult, level);
                break;
            }
            case LADDER: {
                player.teleportTo((double)player.blockPosition().getX(), (double)blockPos.relative(direction).getY(), (double)player.blockPosition().getZ());
                break;
            }
            case LIGHTNING_ROD: {
                CommonEffectsUtil.lightingCausedByPlayer(player, blockPos);
                break;
            }
            case NETHER_STAR: {
                level.explode((Entity)player, (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), 4.0f, Level.ExplosionInteraction.TNT);
                tieredArrowEntity.remove(Entity.RemovalReason.DISCARDED);
                break;
            }
            case PAPER: {
                PaperEffectsUtil.randomBlockEffects(player, blockHitResult);
                break;
            }
            case REDSTONE: {
                if (!level.getBlockState(blockPos).hasProperty((Property)RedStoneOreBlock.LIT)) break;
                level.setBlock(blockPos, (BlockState)level.getBlockState(blockPos).setValue((Property)RedStoneOreBlock.LIT, (Comparable)Boolean.valueOf(true)), 11);
                break;
            }
            case TNT: {
                level.explode((Entity)player, (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), 2.0f, Level.ExplosionInteraction.TNT);
                tieredArrowEntity.remove(Entity.RemovalReason.DISCARDED);
                break;
            }
            case WATER_BOTTLE: {
                if (level.getBlockState(blockPos).hasProperty((Property)CampfireBlock.LIT)) {
                    level.setBlock(blockPos, (BlockState)level.getBlockState(blockPos).setValue((Property)CampfireBlock.LIT, (Comparable)Boolean.valueOf(false)), 11);
                }
                if (!level.getBlockState(relative).is(Blocks.FIRE)) break;
                level.removeBlock(relative, false);
            }
        }
    }
}

